#include "reseau.h"
#include "interface.h"

long res_init(t_serveur *serv)
{
    if (SDLNet_Init() == -1) {return 0;}//Initialise SDL_net pour le rseau
    serv->port = PORT;
    serv->connecte = -1;
    serv->paquets = NULL;
    serv->thread_id = NULL;
    return 1;
}

void res_quit(t_serveur *serv)
{
    if(serv->connecte != -1) {deconnecter(serv);}//On arrte l'coute si c'est ncessaire
    SDLNet_Quit();
    return;
}

long connecter(t_interface *inter, t_serveur *serv, char *host)
{
    char buffer[BUFFER_MAX];

    if(SDLNet_ResolveHost(&(serv->ip), host, serv->port) == 0)
    {
        serv->socket = SDLNet_TCP_Open(&(serv->ip));
        if(serv->socket != NULL)
        {
            serv->paquets = (t_paquet *)malloc(sizeof(t_paquet));
            if(serv->paquets == NULL) {return 0;}
            serv->paquets->taille = 0;
            serv->paquets->donnee = NULL;
            serv->paquets->suivant = NULL;
            serv->thread_id = SDL_CreateThread(ecouter_serveur, serv);
            serv->connecte = 1;
            sprintf(buffer, "Vous tes connect  \"%s:%ld\" !", host, serv->port);
            afficher_message(inter, buffer, 0, 255, 0);
            return 1;
        }
        else
        {
            sprintf(buffer, "Impossible de se connecter  \"%s:%ld\" !", host, serv->port);
            afficher_message(inter, buffer, 255, 0, 0);
            return 0;
        }
    }
    else
    {
        sprintf(buffer, "Erreur DNS : impossible de rsoudre \"%s\" !", host);
        afficher_message(inter, buffer, 255, 0, 0);
        return 0;
    }
}

void deconnecter(t_serveur *serv)
{
    communiquer(ERREUR_DECO, 0, NULL, serv); //On signal au serveur qu'on va se dconnect
    if(serv->connecte == 1) {SDL_KillThread(serv->thread_id);}
    serv->thread_id = NULL;
    supprimer_paquets(serv->paquets); //On supprime la mmoire alloue aux paquets en attente
    serv->paquets = NULL;
    SDLNet_TCP_Close(serv->socket);
    serv->socket = NULL;
    serv->connecte = -1;
    return;
}

int ecouter_serveur(void *param)
{
    t_serveur *s; //Contient les infos du serveur
    t_paquet *paquet, *prec; //Contient les paquets prcdent et en rception
    char temp[8]; //Contient l'en-tte du paquet en rception

    s = (t_serveur *)param; //On rcupre les donnes dans une structure
    prec = s->paquets; //Initialisation de la liste des paquets
    while(SDLNet_TCP_Recv(s->socket, temp, 8) > 0) //Tant qu'il n'y a pas eu de dconnexion ou d'erreur, on lit l'en-tte du paquet
    {
        paquet = (t_paquet *)malloc(sizeof(t_paquet)); //Prpare la mmoire pour rcuprer un paquet
        if(paquet == NULL)
        {
            s->connecte = 0;
            return 1;
        }
        paquet->type = SDLNet_Read32(temp); //On en rcupre le type
        paquet->taille = SDLNet_Read32(temp + 4); //La taille
        paquet->suivant = NULL; //On n'a pas encore rcupr d'autres paquets
        if(paquet->taille != 0) //S'il reste des donnes  rcuprer
        {
            paquet->donnee = (char *)malloc(paquet->taille); //On alloue alors assez de mmoire pour le corps
            if(paquet->donnee == NULL)
            {
                free(paquet);
                s->connecte = 0;
                return 1;
            }
            SDLNet_TCP_Recv(s->socket, paquet->donnee, paquet->taille); //On rcupre enfin le corps du message
        }
        else {paquet->donnee = NULL;} //Sinon on signal qu'il n'y a pas de donnes suplmentaires
        prec->suivant = paquet; //On ajoute le nouveau paquet  liste des paquets  traiter
        prec = paquet; //Le dernier paquet reu est celui-ci
    }
    s->connecte = 0;
    return 0;
}

void supprimer_paquets(t_paquet *paquet)
{
    if(paquet->suivant != NULL) {supprimer_paquets(paquet->suivant);} //S'il y a d'autres paquets, on les supprime
    if(paquet->taille != 0) {free(paquet->donnee);} //S'il y a des donnes  supprimer, on supprime
    free(paquet); //On supprime enfin la structure
    return;
}

long communiquer(type_message type, long taille, char *donnee, t_serveur *serv)
{
    char *paquet; //Stockera le paquet  envoyer

    if(serv->connecte == 1)
    {
        paquet = (char *)malloc(taille + 8); //On alloue donc la mmoire ncssaire
        if(paquet == NULL) {return 0;}
        SDLNet_Write32(type, paquet); //On crit le type dans l'odre pour le rseau
        SDLNet_Write32(taille, paquet + 4); //On crit la taille des donnes dans l'odre pour le rseau
        memcpy(paquet + 8, donnee, taille); //On crit enfin les donnes du message
        if(SDLNet_TCP_Send(serv->socket, paquet, taille + 8) < taille + 8) //On envoie le paquet
        {
            free(paquet);
            return 0; //Si a a rat on signal une erreur
        }
        else
        {
            free(paquet);
            return 1; //Si l'envoie a russi, on le signal
        }
    }
    return 0;
}

void envoyer_message(char *mess, t_serveur *serv)
{
    char buffer[BUFFER_MAX + 4];

    SDLNet_Write32(-1, buffer); //Tous les joueurs sont les destinataires du message
    strcpy(buffer + 4, mess);
    communiquer(MESSAGE, strlen(mess) + 5, buffer, serv);
    return;
}
